/*
	$DOCFILE:COMPILER.H

	Copyright (C) 2000-2001 Datalight, Inc.
	All Rights Reserved

	Compiler specific header file for the 
	Sockets Compatible API (CAPI) 

	$DOCHISTORY:
	     05/11/2001 jmb updated ISR_ROUTINE
	     03/29/2001 jmb removed MSVC compatibility changaes -- caused too
	                    many problems.
	     03/20/2001 jmb Fixed REALMODE_SEGMENT, REALMODE_OFFSET and
		                 MAKE_REAL POINTERS macros to work under MSVC.
							  I also added a #define for interrupt to be
							  compatible with MSVC.
	1.00 2000-11-29 pkg Extracted from CAPI.H
*/

/*
	This define must be set to produce a 32 bit (seg:off pointer)
*/
#define D_FAR far

/*
	Function declaration prefix, if any, for an ISR routine.
*/
#define ISR_ROUTINE __loadds


/*
	Portable types which must be set:
	BYTE (8bits) WORD (16bits) DWORD (32bits)
*/
#ifndef __WIN_TYPES
 #define __WIN_TYPES
 typedef unsigned char BYTE;
 typedef unsigned short WORD;
 typedef unsigned long DWORD;
#endif


/*
	The following macros are used to work with both native
	and real mode pointers and buffers.  Each is generally
	unique to a given compiler and environment.  For
	example, an application using the 32-bit DJGPP compiler
	will require a specially allocated buffer and a
	means to move data between both native and real mode
	buffers.

	Each macro must be carefully written for a particular
	environment.
*/
#define REALMODE_SEGMENT(p)     (WORD)((DWORD)(p) >> 16L)
#define REALMODE_OFFSET(p)      (WORD)((DWORD)(p) & 0xFFFFL)
#define MAKE_REAL_POINTER(s, o) (DWORD)(((DWORD)(s) << 16L) \
                                   + ((DWORD)(o) &0xFFFFL))


/*
	The compatibility API is called called by setting up
	the CPU registers and memory structures and issueing
	an interrupt 0x61 (or appropriate interrupt)  The 
	following macros provide a semi-portable means of
	embedding assembly code in C code.
*/

#include <dos.h>

/* Microsoft C uses _asm and cflag */
#ifdef _MSC_VER
  #ifdef _ASM
        #undef _ASM
  #endif
  #define _ASM _asm
#endif

/* Borland C uses asm and flags*/
#ifdef __TURBOC__
 #ifdef _ASM
  #undef _ASM
 #endif
 #define _ASM asm
#endif

/*
	These are required for Borland and Microsoft C, other
	compilers may or may not use them.  The following
	macros must be defined appropriately.
*/
#ifndef _ASM
 #error _ASM not defined.  Required for _CAPI
#endif

/*
	MSDELAY must be defined to sleep or delay execution
	for the given number of milliseconds.  Note this is
	only used for testing purposes.
*/
#ifdef WIN32
 #define MSDELAY(x) sleep((x))
#else
 #define MSDELAY(x) delay((x))
#endif


/*
	The interface to the Sockets driver is performed via
	a software interrupt with appropriate registers
	set to indicate the function, various parameters,
	and to pass pointers for data transfer.
*/
typedef struct _tagX86Regs
{
	WORD	ax;
	WORD	bx;
	WORD	cx;
	WORD	dx;
	WORD	si;
	WORD	di;
	WORD	ds;
	WORD	es;
} X86Regs;


/* Global API calls used within the Sockets Compatible API */
int CallSocketsDosApi(X86Regs *px86regs);

